DECLARE SUB EditFORM ()
'-------------------------------------------
'JUNE 1, 1996  by Michael J. Gothelf
'
'Sample of Masked input code .... Can be linked into a library
'There are NO ROYALTIES.
'
'DISCLAIMER: I am not responsible for SYSTEM failures, use at your own risk.
'-------------------------------------------
DECLARE FUNCTION EditFIELD% (FieldNo%, FieldINFO() AS ANY, FieldData$(), FieldDefault$())
DEFINT A-Z
'$INCLUDE: 'MASKINPT.CAL'
'$INCLUDE: 'FLDUTIL.CAL'
'$INCLUDE: 'SCRNUTIL.CAL'

'$INCLUDE: 'FLDINFO.TYP'
'$INCLUDE: 'COLORS.CON'

CONST TRUE% = -1, FALSE% = 0    '<- Good to have in all code

'------------[MAIN CODE]----------
REDIM SHARED FieldINFO(0)   AS FieldINFOtype  '<- Information about the field
REDIM SHARED FieldData$(0)                    '<- Storage for field info.
REDIM SHARED FieldDefault$(0)                 '<- Storage for field default
                                              '   value.

'- Load in the field information & display a screen -
CALL SetupFields(FieldINFO(), FieldData$(), FieldDefault$())

CLS
CALL DisplaySCRN
CALL PrintFLDS(1, 3, FieldINFO(), FieldData$())

'------[Data Entry Loop]-----------------------------------------
CALL EditFORM
'------[Display Data Entered]------------------------------------
CLS
PRINT "------[The following is the information entered into the fields]-----"
FOR FieldNo = 1 TO UBOUND(FieldINFO)
  PRINT FieldINFO(FieldNo).Name; "="; FieldData$(FieldNo)
NEXT FieldNo

'------[End of application]--------------------------------------
COLOR WHITE, BLACK    '<- Reset the color to WHITE on BLACK
END

FUNCTION EditFIELD% (FieldNo%, FieldINFO() AS FieldINFOtype, FieldData$(), FieldDefault$())
  COL = FieldINFO(FieldNo).POSx: ROW = FieldINFO(FieldNo).POSy
  CharCOLOR = FieldINFO(FieldNo).ColorCHAR
  BackCOLOR = FieldINFO(FieldNo).ColorBACK

  FldType = FieldINFO(FieldNo).FType
  StrINPUT$ = FieldData$(FieldNo)

  '-Get the mask information for this field type
  Mask$ = MaskINFO$(FieldINFO(FieldNo).FType, FieldINFO(FieldNo).Length, FieldINFO(FieldNo).Decimal)

  '- Convert Field Data to Display format
  EditSTR$ = Str2Mask$(StrINPUT$, Mask$)

  '- Get the line input
  TermCode = GetLineInput(COL, ROW, EditSTR$, Mask$, CharCOLOR, BackCOLOR)

  '- Get the field data from the Masked format
  FieldData$(FieldNo) = Mask2Str$(EditSTR$, Mask$)
  '- Once here...you need to verify that the Data entered is valid...

'----------[Verify code goes here!]
'----------------------------------

  '- Re-Display the string..this is for formating...and verifying
  '  field information such as numbers in a date field!
  PrintSTR COL, ROW, EditSTR$, CharCOLOR, BackCOLOR
  
  COLOR WHITE, BLACK    '<- Reset the color to WHITE on BLACK
  EditFIELD = TermCode
END FUNCTION

SUB EditFORM

  FieldNo = 1: MaxFIELDS = UBOUND(FieldINFO)
  DO
    TermCode = EditFIELD(FieldNo, FieldINFO(), FieldData$(), FieldDefault$())
    SELECT CASE TermCode
      CASE 13:                     '<- Enter Key ...move forward
        FieldNo = FieldNo + 1: IF (FieldNo > MaxFIELDS) THEN FieldNo = 1
      CASE -15:                    '<- Shift Tab backward
        FieldNo = FieldNo - 1: IF (FieldNo < 1) THEN FieldNo = MaxFIELDS
      CASE 9:                      '<- Tab forward
        FieldNo = FieldNo + 1: IF (FieldNo > MaxFIELDS) THEN FieldNo = 1
      CASE 27:                     '<- Escape key
    END SELECT
  LOOP UNTIL TermCode = 27    '<-ESC key

END SUB

